import numpy as np
import numpy.polynomial.polynomial as npp
import scipy.optimize as opt

t = [0.005, 0.010, 0.015, 0.020, 0.025, 0.030]
v = [8.7, 6.3, 4.5, 3.3, 2.4, 1.7]


def linear(t, b, m):
    return b + m*t

def exponential(t, a, b):
    return a*np.exp(-t/b)

y = np.log(v)

coef = npp.polyfit(t, y, 1)
b, m = coef

v_0 = np.exp(b)
c = - 1e+6/(m*47e+3)

print(f'{v_0:.1f}', f'{c:.3f}')


p0 = 10, 0.01
popt, pcov = opt.curve_fit(exponential, t, v, p0)

v_0 = popt[0]
c = 1e+6*popt[1]/47e+3

print(f'{v_0:.1f}', f'{c:.3f}')

